"use client";

import { useState } from "react";

export default function Navigation() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <nav className="fixed top-0 left-0 right-0 z-50 bg-anthracite-dark/95 backdrop-blur-sm border-b border-anthracite/20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-20">
          <div className="flex-shrink-0">
            <h1 className="text-2xl font-bold text-white tracking-tight">
              CELEP
            </h1>
          </div>

          {/* Desktop Menu */}
          <div className="hidden md:flex md:space-x-8">
            <a href="#hizmetler" className="text-gray-300 hover:text-petrol transition-colors">
              Hizmetler
            </a>
            <a href="#hakkimizda" className="text-gray-300 hover:text-petrol transition-colors">
              Hakkımızda
            </a>
            <a href="#iletisim" className="text-gray-300 hover:text-petrol transition-colors">
              İletişim
            </a>
            <a
              href="#iletisim"
              className="bg-petrol text-white px-6 py-2 rounded-sm hover:bg-petrol-light transition-colors"
            >
              Teklif Al
            </a>
          </div>

          {/* Mobile Menu Button */}
          <button
            className="md:hidden text-gray-300"
            onClick={() => setIsMenuOpen(!isMenuOpen)}
            aria-label="Menu"
          >
            <svg className="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              {isMenuOpen ? (
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M6 18L18 6M6 6l12 12" />
              ) : (
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
              )}
            </svg>
          </button>
        </div>

        {/* Mobile Menu */}
        {isMenuOpen && (
          <div className="md:hidden pb-4 space-y-3">
            <a href="#hizmetler" className="block text-gray-300 hover:text-petrol transition-colors">
              Hizmetler
            </a>
            <a href="#hakkimizda" className="block text-gray-300 hover:text-petrol transition-colors">
              Hakkımızda
            </a>
            <a href="#iletisim" className="block text-gray-300 hover:text-petrol transition-colors">
              İletişim
            </a>
            <a
              href="#iletisim"
              className="block bg-petrol text-white px-6 py-2 rounded-sm hover:bg-petrol-light transition-colors text-center"
            >
              Teklif Al
            </a>
          </div>
        )}
      </div>
    </nav>
  );
}

