export default function HeroSection() {
  return (
    <section className="pt-32 pb-20 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="space-y-8">
            <div className="space-y-4">
              <h1 className="text-5xl md:text-6xl lg:text-7xl font-bold text-white leading-tight">
                Endüstriyel
                <br />
                <span className="text-petrol">Teknik Hizmetler</span>
              </h1>
              <p className="text-xl text-gray-300 max-w-2xl">
                Havalandırma ve toz toplama sistemleri için profesyonel montaj, 
                bakım ve bileşen tedariki. 28+ yıllık deneyimle endüstriyel 
                tesislerinize güvenilir çözümler.
              </p>
            </div>
            
            <div className="flex flex-col sm:flex-row gap-4">
              <a
                href="#iletisim"
                className="bg-petrol text-white px-8 py-4 rounded-sm hover:bg-petrol-light transition-all duration-200 text-center font-medium"
              >
                Hemen İletişime Geçin
              </a>
              <a
                href="#hizmetler"
                className="border-2 border-gray-600 text-white px-8 py-4 rounded-sm hover:border-petrol hover:text-petrol transition-all duration-200 text-center font-medium"
              >
                Hizmetlerimiz
              </a>
            </div>
          </div>

          <div className="relative">
            <div className="aspect-[4/3] bg-anthracite rounded-sm overflow-hidden border border-gray-700">
              <img
                src="https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?w=1200&q=80&auto=format&fit=crop"
                alt="Endüstriyel havalandırma sistemi"
                className="w-full h-full object-cover"
              />
            </div>
            <div className="absolute -bottom-6 -left-6 w-24 h-24 bg-petrol/20 border border-petrol/30"></div>
          </div>
        </div>
      </div>
    </section>
  );
}

