export default function Footer() {
  return (
    <footer className="bg-anthracite border-t border-gray-700 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        <div className="grid md:grid-cols-4 gap-8 mb-8">
          <div>
            <h3 className="text-2xl font-bold text-white mb-4">CELEP</h3>
            <p className="text-gray-400 text-sm">
              Endüstriyel havalandırma ve toz toplama sistemleri için 
              güvenilir teknik hizmet ortağınız.
            </p>
          </div>
          
          <div>
            <h4 className="text-white font-semibold mb-4">Hizmetler</h4>
            <ul className="space-y-2 text-gray-400 text-sm">
              <li><a href="#hizmetler" className="hover:text-petrol transition-colors">Montaj</a></li>
              <li><a href="#hizmetler" className="hover:text-petrol transition-colors">Bakım</a></li>
              <li><a href="#hizmetler" className="hover:text-petrol transition-colors">Bileşen Tedariki</a></li>
              <li><a href="#hizmetler" className="hover:text-petrol transition-colors">Acil Servis</a></li>
            </ul>
          </div>
          
          <div>
            <h4 className="text-white font-semibold mb-4">Şirket</h4>
            <ul className="space-y-2 text-gray-400 text-sm">
              <li><a href="#hakkimizda" className="hover:text-petrol transition-colors">Hakkımızda</a></li>
              <li><a href="#iletisim" className="hover:text-petrol transition-colors">İletişim</a></li>
              <li><a href="#iletisim" className="hover:text-petrol transition-colors">Teklif Al</a></li>
            </ul>
          </div>
          
          <div>
            <h4 className="text-white font-semibold mb-4">İletişim</h4>
            <ul className="space-y-2 text-gray-400 text-sm">
              <li>Tel: +90 555 123 45 67</li>
              <li>E-posta: info@celep.com</li>
              <li>24/7 Acil: +90 555 123 45 67</li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-gray-700 pt-8 text-center text-gray-500 text-sm">
          <p>&copy; {new Date().getFullYear()} CELEP. Tüm hakları saklıdır.</p>
        </div>
      </div>
    </footer>
  );
}

