export default function CoreServices() {
  const services = [
    {
      title: "Montaj Hizmetleri",
      description: "Endüstriyel havalandırma ve toz toplama sistemlerinin profesyonel montajı. Scheuch, SGS ve diğer önde gelen markalar için uzman kurulum.",
      image: "https://images.unsplash.com/photo-1581092160562-40aa08e78837?w=800&q=80&auto=format&fit=crop",
      features: [
        "Profesyonel ekip ve ekipman",
        "Proje yönetimi ve planlama",
        "Kalite garantili kurulum"
      ]
    },
    {
      title: "Bakım ve Onarım",
      description: "Periyodik bakım, arıza giderme ve sistem optimizasyonu. Maksimum verimlilik için düzenli kontrol ve bakım programları.",
      image: "https://images.unsplash.com/photo-1581091226825-a6a2a5aee158?w=800&q=80&auto=format&fit=crop",
      features: [
        "Önleyici bakım programları",
        "7/24 acil müdahale",
        "Sistem performans optimizasyonu"
      ]
    },
    {
      title: "Bileşen Tedariki",
      description: "Orijinal yedek parça ve bileşen tedariki. Hızlı teslimat ve geniş stok yelpazesi ile kesintisiz üretim.",
      image: "https://images.unsplash.com/photo-1565793298595-6a879b1d9492?w=800&q=80&auto=format&fit=crop",
      features: [
        "Orijinal ve uyumlu parçalar",
        "Hızlı teslimat",
        "Teknik danışmanlık"
      ]
    }
  ];

  return (
    <section id="hizmetler" className="py-24 px-4 sm:px-6 lg:px-8 bg-anthracite-dark">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-4">
            Temel Hizmetlerimiz
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            Endüstriyel tesisleriniz için kapsamlı teknik hizmet çözümleri
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8">
          {services.map((service, index) => (
            <div
              key={index}
              className="bg-anthracite border border-gray-700 rounded-sm overflow-hidden hover:border-petrol/50 transition-all duration-300 group"
            >
              <div className="aspect-video overflow-hidden bg-gray-800">
                <img
                  src={service.image}
                  alt={service.title}
                  className="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                />
              </div>
              <div className="p-8">
                <h3 className="text-2xl font-bold text-white mb-4 group-hover:text-petrol transition-colors">
                  {service.title}
                </h3>
                <p className="text-gray-300 mb-6 leading-relaxed">
                  {service.description}
                </p>
                <ul className="space-y-3">
                  {service.features.map((feature, idx) => (
                    <li key={idx} className="flex items-start gap-3 text-gray-400">
                      <svg className="w-5 h-5 text-petrol flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
                      </svg>
                      <span>{feature}</span>
                    </li>
                  ))}
                </ul>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}

