export default function ConfidenceMetrics() {
  const metrics = [
    {
      number: "28+",
      label: "Yıl Deneyim",
      description: "Endüstriyel havalandırma ve toz toplama sistemlerinde derinlemesine uzmanlık"
    },
    {
      number: "500+",
      label: "Tamamlanan Proje",
      description: "Başarıyla tamamlanmış montaj, bakım ve modernizasyon projeleri"
    },
    {
      number: "98%",
      label: "Müşteri Memnuniyeti",
      description: "Kaliteli hizmet ve güvenilir çözümlerle yüksek memnuniyet oranı"
    }
  ];

  return (
    <section className="py-24 px-4 sm:px-6 lg:px-8 bg-anthracite border-y border-gray-700">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold text-white mb-4">
            Güvenilir Teknik Ortak
          </h2>
          <p className="text-xl text-gray-300 max-w-3xl mx-auto">
            Rakamlarla başarı hikayemiz
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8">
          {metrics.map((metric, index) => (
            <div
              key={index}
              className="text-center p-8 bg-anthracite-dark border border-gray-700 rounded-sm hover:border-petrol/50 transition-all duration-300"
            >
              <div className="mb-4">
                <span className="text-6xl md:text-7xl font-bold text-petrol block">
                  {metric.number}
                </span>
              </div>
              <h3 className="text-2xl font-semibold text-white mb-3">
                {metric.label}
              </h3>
              <p className="text-gray-400 leading-relaxed">
                {metric.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}

